## Pipelines again solution

~~~
import "Simantics/DB"
import "http://www.simantics.org/Layer0-1.1" as L0
import "http://www.simantics.org/Modeling-1.2" as MOD
import "http://www.simantics.org/Diagram-2.2" as DIA
import "http://www.apros.fi/Combustion/Configuration-6.0" as Conf

swap (x,y) = (y,x)

connectPoint1 :: Resource -> <ReadGraph> Resource
connectPoint1 r = do
    c = singleObject r Conf.Relations.PI12_CONNECT_POINT_1_1_1
    singleObject c Conf.Relations.SelfPOINT.Inverse

connectPoint2 :: Resource -> <ReadGraph> Resource
connectPoint2 r = do
    c = singleObject r Conf.Relations.PI12_CONNECT_POINT_2_1_1
    singleObject c Conf.Relations.SelfPOINT.Inverse

readDiagram :: Resource -> <ReadGraph,Proc> ()
readDiagram dia = do
    points = filter (flip isInstanceOf Conf.ModuleTypes.POINT) (dia # L0.ConsistsOf)
    indexedPoints = zip [0..length points] points
    for indexedPoints $ \(i,r) -> do
        trans = relatedValue (singleObject r MOD.ComponentToElement) DIA.HasTransform :: [Double]
        print "POINT;\(i);\(relatedValue r Conf.Relations.PO11_ELEV :: Float);\(trans!4);\(trans!5)"
    pointByResource = index (map swap indexedPoints)
    pipes = filter (flip isInstanceOf Conf.ModuleTypes.PIPE) (dia # L0.ConsistsOf)
    for pipes $ \r -> do
        id1 = fromJust (pointByResource (connectPoint1 r))
        id2 = fromJust (pointByResource (connectPoint2 r))
        print "PIPE;\(id1);\(id2);\(relatedValue r Conf.Relations.PI12_LENGTH :: Float)"
~~~